#==============================================================================
#  FuzzyAttack
#------------------------------------------------------------------------------
# U`h
# Copyright (C) 2005 fukuyama
#==============================================================================

module Battle_AI

class AutoAttack_Type1 < Battle_AI_Base
	HP_LABELS = ['m','d','','y','']
	def make_action
		fs_target_hp_list = []
		for target in targets
			maxhp = target.maxhp
			hp = target.hp
			fs = FuzzySet.new
			fs.create_fuzzy_labels = HP_LABELS
			fs.create_fuzzy_set [0,maxhp *1/4,maxhp * 2/4,maxhp * 3/4,maxhp]
			fs.member_ship hp
			fs_target_hp_list.push fs
		end
		HP_LABELS.each do |label|
			fs_target_hp_list.each_index do |i|
				fs = fs_target_hp_list[i]
				if fs.result_name == label
					setup_normal_attack(targets[i])
					return
				end
			end
		end
		setup_normal_attack(targets[0])
	end
end

end
